<!DOCTYPE html>
<html lang="id">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Scard-project</title>
  <style>
    * {
      margin: 0;
      padding: 0;
      box-sizing: border-box;
    }

    body {
      font-family: Arial, sans-serif;
      height: 100vh;
      background: #800080; /* Background ungu kekinian */
      display: flex;
      justify-content: center;
      align-items: center;
      overflow: hidden;
    }

    .container {
      position: relative;
      display: flex;
      justify-content: center;
      align-items: center;
      width: 100%;
      height: 100%;
    }

    .content {
      text-align: center;
      background: rgba(255, 255, 255, 0.1);
      padding: 20px;
      border-radius: 10px;
      backdrop-filter: blur(10px);  /* Efek kaca seperti iOS */
      box-shadow: 0 4px 6px rgba(0, 0, 0, 0.2);
      color: #fff;
      max-width: 80%;
      font-size: 2rem;
      animation: fadeIn 2s ease-in-out, changeText 10s infinite; /* Animasi transisi dan perubahan teks */
    }

    h1 {
      font-size: 2.5rem;
      text-shadow: 2px 2px 5px rgba(0, 0, 0, 0.3);
    }

    /* Efek animasi untuk fadeIn */
    @keyframes fadeIn {
      0% {
        opacity: 0;
        transform: translateY(30px);
      }
      100% {
        opacity: 1;
        transform: translateY(0);
      }
    }

    /* Efek animasi perubahan teks setiap 10 detik */
    @keyframes changeText {
      0% {
        content: "Mau cari janda? Tidak ada di sini";
      }
      25% {
        content: "Cari jodoh? Kamu lebih baik di sini!";
      }
      50% {
        content: "Mencari pasangan? Jangan di sini ya!";
      }
      75% {
        content: "Tunggu apa lagi? Cari tempat lain!";
      }
      100% {
        content: "Mau cari janda? Tidak ada di sini";
      }
    }
  </style>
</head>
<body>
  <div class="container">
    <div class="content">
      <h1 id="text">Mau cari janda? Tidak ada di sini</h1>
    </div>
  </div>

  <script>
    const phrases = [
      "Mau cari janda? Tidak ada di sini",
      "Cari jodoh? Kamu lebih baik di sini!",
      "Mencari pasangan? Jangan di sini ya!",
      "Tunggu apa lagi? Cari tempat lain!"
    ];

    let currentPhraseIndex = 0;
    const textElement = document.getElementById('text');

    // Fungsi untuk mengubah teks setiap beberapa detik
    setInterval(() => {
      textElement.textContent = phrases[currentPhraseIndex];
      currentPhraseIndex = (currentPhraseIndex + 1) % phrases.length;
    }, 4000); // Ubah teks setiap 4 detik
  </script>
</body>
</html>