<?php
// deposit.php
header("Content-Type: application/json");

$SECRET_KEY = "superRahasiaBanget123";

// Koneksi Database
$host = "localhost";
$user = "scac8254_ceirgo";
$pass = "scac8254_ceirgo";
$db   = "scac8254_ceirgo"; 

$conn = new mysqli($host, $user, $pass, $db);
if ($conn->connect_error) {
    die(json_encode(["success" => false, "msg" => "Database error"]));
}

// Ambil raw input
$raw = file_get_contents("php://input");
$data = json_decode($raw, true);

if (!$data) {
    echo json_encode(["success" => false, "msg" => "Invalid request"]);
    exit;
}

// Ambil parameter
$target    = $data['target'] ?? null; // bisa phone/username/email
$amount    = $data['amount'] ?? null;
$signature = $data['signature'] ?? null;

// Validasi input
if (!$target || !$amount || !$signature) {
    echo json_encode(["success" => false, "msg" => "Missing parameters"]);
    exit;
}

// Buat ulang signature di server untuk validasi
$payload   = json_encode(["target" => $target, "amount" => (int)$amount], JSON_UNESCAPED_SLASHES);
$serverSig = hash_hmac("sha256", $payload, $SECRET_KEY);

if (!hash_equals($serverSig, $signature)) {
    echo json_encode(["success" => false, "msg" => "Invalid signature"]);
    exit;
}

// Tentukan cara pencarian user
$field = "no_hp"; // default
if (filter_var($target, FILTER_VALIDATE_EMAIL)) {
    $field = "email";
} elseif (preg_match('/^\d+$/', $target)) {
    $field = "no_hp";
} else {
    $field = "username";
}

// Cari user di DB
$stmt = $conn->prepare("SELECT id, username, saldo FROM users WHERE $field = ?");
$stmt->bind_param("s", $target);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows === 0) {
    echo json_encode(["success" => false, "msg" => "User tidak ditemukan"]);
    exit;
}

$user = $result->fetch_assoc();
$saldo_awal = (int)$user['saldo'];
$newSaldo   = $saldo_awal + (int)$amount;

// Update saldo user
$update = $conn->prepare("UPDATE users SET saldo = ? WHERE id = ?");
$update->bind_param("ii", $newSaldo, $user['id']);
$update->execute();

// Tambahkan log ke history_saldo
$date  = date("Y-m-d");
$time  = date("H:i:s");
$aksi  = "Penambahan Saldo";
$pesan = "Deposit melalui bot WhatsApp";

$log = $conn->prepare("INSERT INTO history_saldo (username, aksi, nominal, pesan, date, time) VALUES (?, ?, ?, ?, ?, ?)");
$log->bind_param("ssdsss", $user['username'], $aksi, $amount, $pesan, $date, $time);
$log->execute();

echo json_encode([
    "success" => true,
    "msg"     => "Deposit berhasil",
    "target"  => $target,
    "amount"  => (int)$amount,
    "saldo_awal" => $saldo_awal,
    "saldo_akhir"=> $newSaldo
]);
