(function ( $ ) {
	function pad(n) {
	    return (n < 10) ? ("0" + n) : n;
	}

	$.fn.showclock = function(obj) {
	    
	    var currentDate=new Date();
	    var fieldDate=$(this).data('date').split('-');
	    var futureDate=new Date(fieldDate[0],fieldDate[1]-1,fieldDate[2]);
	    var seconds=futureDate.getTime() / 1000 - currentDate.getTime() / 1000;

		var coundDownObj = coundDown = {
			countDown_days: "Days",
			countDown_hours: "Hours",
			countDown_minutes: "Minutes",
			countDown_seconds: "Seconds"
		};

		if (obj.countDown_days) {
			coundDownObj.countDown_days = obj.countDown_days;
		}
		if (obj.countDown_hours) {
			coundDownObj.countDown_hours = obj.countDown_hours;
		}
		if (obj.countDown_minutes) {
			coundDownObj.countDown_minutes = obj.countDown_minutes;
		}
		if (obj.countDown_seconds) {
			coundDownObj.countDown_seconds = obj.countDown_seconds;
		}

	    if(seconds<=0 || isNaN(seconds)){
	    	this.hide();
	    	return this;
	    }

	    var days=Math.floor(seconds/86400);
	    seconds=seconds%86400;
	    
	    var hours=Math.floor(seconds/3600);
	    seconds=seconds%3600;

	    var minutes=Math.floor(seconds/60);
	    seconds=Math.floor(seconds%60);
	    
	    var html="";

	    if(days!=0){
		    html+="<div class='countdown-container days'>"
		    	html+="<span class='countdown-heading days-top'>"+pad(days)+"</span>";
		    	html+="<span class='countdown-value days-bottom'>"+obj.countDown_days+"</span>";
		    html+="</div>";
		}

	    html+="<div class='countdown-container hours'>"
	    	html+="<span class='countdown-heading hours-top'>"+pad(hours)+"</span>";
	    	html+="<span class='countdown-value hours-bottom'>"+obj.countDown_hours+"</span>";
	    html+="</div>";

	    html+="<div class='countdown-container minutes'>"
	    	html+="<span class='countdown-heading minutes-top'>"+pad(minutes)+"</span>";
	    	html+="<span class='countdown-value minutes-bottom'>"+obj.countDown_minutes+"</span>";
	    html+="</div>";

	    html+="<div class='countdown-container seconds'>"
	    	html+="<span class='countdown-heading seconds-top'>"+pad(seconds)+"</span>";
	    	html+="<span class='countdown-value seconds-bottom'>"+obj.countDown_seconds+"</span>";
	    html+="</div>";

	    this.html(html);
	};

	$.fn.countdown = function(obj) {
		var el=$(this);
		el.showclock(obj);
		setInterval(function(){
			el.showclock(obj);
		},1000);
		
	}

}(jQuery));
