<?php
/****************************************************
 * Admin Youth Registrations – versi sederhana (fixed)
 * Tabel: youth_registrations
 * Kolom: nama · whatsapp · gereja · alamat · registered_at (DATETIME)
 *
 * PERUBAHAN UTAMA (tanpa mengubah tampilan/sistem):
 * - Pindahkan seluruh logika PHP ke atas agar export XLS tidak terganggu header yang sudah terkirim.
 * - Hilangkan dokumen HTML ganda di dalam <div class="glass-card"> (tidak lagi ada <!DOCTYPE> kedua).
 * - Tetap pertahankan struktur & gaya tampilan seperti semula.
 ****************************************************/

// ============ KONFIGURASI DB ============
$DB_HOST = "localhost";
$DB_USER = "scac8254_tes";
$DB_PASS = "scac8254_tes"; // kosongkan jika tidak ada password
$DB_NAME = "scac8254_tes";

date_default_timezone_set('Asia/Jakarta');

// Koneksi
$mysqli = @new mysqli($DB_HOST, $DB_USER, $DB_PASS, $DB_NAME);
if ($mysqli->connect_error) {
  http_response_code(500);
  die("Koneksi database gagal: " . htmlspecialchars($mysqli->connect_error));
}
$mysqli->set_charset("utf8mb4");

// Hitung total
$totalRows = 0;
$resCount = $mysqli->query("SELECT COUNT(*) AS total FROM youth_registrations");
if ($resCount) {
  $row = $resCount->fetch_assoc();
  $totalRows = (int)($row['total'] ?? 0);
  $resCount->close();
}

// Ambil data
$sql = "SELECT nama, whatsapp, gereja, alamat, registered_at
        FROM youth_registrations
        ORDER BY registered_at DESC";
$res = $mysqli->query($sql);
$rows = [];
if ($res) {
  while ($r = $res->fetch_assoc()) $rows[] = $r;
  $res->close();
}

// ===== Export Excel =====
if (isset($_GET['export']) && $_GET['export'] === 'xls') {
  $filename = "youth_registrations_" . date("Ymd_His") . ".xls";
  // Pastikan belum ada output sebelum header
  if (ob_get_length()) { ob_end_clean(); }
  header("Content-Type: application/vnd.ms-excel; charset=UTF-8");
  header("Content-Disposition: attachment; filename=\"{$filename}\"");
  header("X-Content-Type-Options: nosniff");

  echo "<html><head><meta charset=\"UTF-8\"></head><body>";
  echo "<table border='1' cellspacing='0' cellpadding='6'>";
  echo "<tr style='font-weight:bold;background:#eaeaea'>
          <td>Nama</td><td>WhatsApp</td><td>Gereja</td><td>Alamat</td><td>Tgl Register</td>
        </tr>";
  foreach ($rows as $r) {
    $nama   = htmlspecialchars($r['nama'] ?? '');
    $wa     = htmlspecialchars($r['whatsapp'] ?? '');
    $gereja = htmlspecialchars($r['gereja'] ?? '');
    $alamat = htmlspecialchars((string)($r['alamat'] ?? ''));
    $tglRaw = $r['registered_at'] ?? '';
    $tgl    = $tglRaw ? htmlspecialchars(date('d-m-Y H:i', strtotime($tglRaw)) . " WIB") : '';
    echo "<tr>
            <td>{$nama}</td>
            <td>{$wa}</td>
            <td>{$gereja}</td>
            <td>{$alamat}</td>
            <td>{$tgl}</td>
          </tr>";
  }
  echo "</table>";
  echo "</body></html>";
  $mysqli->close();
  exit;
}

function esc($s){ return htmlspecialchars((string)$s, ENT_QUOTES, 'UTF-8'); }
?><!DOCTYPE html><html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>By SCARD-PROJECT</title>
    <link rel="icon" href="asecet/icon.png" type="image/x-icon"><!-- Font Awesome -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
<!-- Bootstrap CSS -->
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/css/bootstrap.min.css" rel="stylesheet">
<!-- AOS -->
<link href="https://unpkg.com/aos@2.3.1/dist/aos.css" rel="stylesheet">

<style>
    @import url('https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700;800;900&display=swap');

    body {
        font-family: 'Poppins', sans-serif;
        background: conic-gradient(from -45deg, #ca49f7, #5a8ade, #62c6e0, #ca49f7);
        padding: 10px;
        display: flex;
        flex-direction: column;
        min-height: 100vh;
        margin: 0;
        overflow-x: hidden;
    }

    /* Overlay */
    .overlay {
        position: fixed;
        top: 0; left: 0;
        width: 100%; height: 100%;
        background: rgba(0,0,0,0.35);
        opacity: 0; visibility: hidden;
        transition: opacity 0.35s ease;
        z-index: 1000;
    }
    .overlay.active { opacity: 1; visibility: visible; }

    /* Sidebar */
    .sidebar {
        position: fixed; top: 0; left: 0;
        width: 270px; height: 100vh;
        background: rgba(255,255,255,0.15);
        backdrop-filter: blur(20px);
        color: white;
        padding-top: 70px;
        z-index: 1100;
        border-top-right-radius: 30px;
        border-bottom-right-radius: 30px;
        box-shadow: 4px 0 20px rgba(0,0,0,0.25);
        transform: translateX(-100%);
        transition: transform 0.35s cubic-bezier(0.25, 1, 0.3, 1);
    }
    .sidebar.active { transform: translateX(0); }
    .sidebar ul { list-style: none; padding: 0; margin: 0; }
    .sidebar ul li a {
        display: flex; align-items: center;
        padding: 14px 20px; margin: 6px 12px;
        border-radius: 12px; color: white;
        text-decoration: none; font-size: 16px;
    }
    .sidebar ul li a:hover {
        background: rgba(255,255,255,0.25);
    }
    .sidebar ul li a.active {
        background: rgba(0,123,255,0.35);
        box-shadow: inset 0 0 8px rgba(0,123,255,0.6);
    }
    .sidebar ul li i { margin-right: 14px; font-size: 20px; width: 25px; text-align: center; }

    /* Navbar */
    #navbar-top { position: sticky; top: 10px; z-index: 999; }
    .menu-btn { font-size: 24px; cursor: pointer; margin-right: 15px; color: #fff; }

    /* Konten */
    .glass-card {
        backdrop-filter: blur(20px);
        background: rgba(255, 255, 255, 0.25);
        border-radius: 20px;
        padding: 22px;
        max-width: 420px;
        width: 100%;
        color: #ffffff;
        box-shadow: 0 8px 24px rgba(0,0,0,0.15);
        margin: 20px auto;
    }
    h2 {
        text-align: center;
        font-size: 20px;
        margin-bottom: 6px;
        font-weight: 600;
        color: #ffffff;
    }
    .owner {
        text-align: center;
        font-size: 14px;
        color: #555;
        margin-bottom: 20px;
    }
    .account {
        background: rgba(255,255,255,0.6);
        padding: 14px 16px;
        border-radius: 14px;
        margin-bottom: 14px;
        display: flex;
        justify-content: space-between;
        align-items: center;
        box-shadow: inset 0 0 6px rgba(0,0,0,0.05);
    }
    .label { font-size: 13px; font-weight: 500; color: #666; margin-bottom: 2px; }
    .number { font-size: 16px; font-weight: 600; color: #fafafa; letter-spacing: 0.5px; }
    .copy-btn { background: rgba(0,0,0,0.05); border: none; border-radius: 8px; cursor: pointer; font-size: 16px; padding: 6px 10px; color: #007aff; transition: all 0.25s ease; }
    .copy-btn:hover { background: rgba(0,0,0,0.1); }
    .upload-box { text-align: center; margin-top: 15px; padding: 15px; background: rgba(255,255,255,0.6); border-radius: 14px; cursor: pointer; border: 2px dashed rgba(0,0,0,0.1); transition: all 0.25s ease; font-size: 14px; color: #555; }
    .upload-box:hover { background: rgba(255,255,255,0.8); }
    .upload-box input { display: none; }
    .preview-img { max-width: 100%; margin-top: 10px; border-radius: 12px; display: none; }
    textarea { width: 100%; margin-top: 12px; padding: 12px; border-radius: 12px; border: 1px solid rgba(0,0,0,0.1); resize: none; font-family: inherit; font-size: 14px; background: rgba(255,255,255,0.6); transition: border 0.2s ease; }
    textarea:focus { border: 1px solid #007aff; outline: none; }
    button.send { margin-top: 15px; width: 100%; padding: 14px; border: none; border-radius: 12px; background: linear-gradient(135deg, #007aff, #0051c3); color: white; font-size: 16px; font-weight: 500; cursor: pointer; box-shadow: 0 4px 12px rgba(0,122,255,0.3); transition: all 0.3s ease; }
    button.send:hover { background: linear-gradient(135deg, #0066d6, #003e99); box-shadow: 0 6px 16px rgba(0,122,255,0.4); }
    /* Toast Notification */
    #toast { visibility: hidden; min-width: 220px; background-color: rgba(0,0,0,0.85); color: #fff; text-align: center; border-radius: 10px; padding: 12px; position: fixed; z-index: 1; left: 50%; bottom: 30px; transform: translateX(-50%); font-size: 14px; opacity: 0; transition: opacity 0.4s, visibility 0.4s; }
    #toast.show { visibility: visible; opacity: 1; }

    /* Admin table area */
    .card{max-width:1100px;margin:auto;background:#ffffff00;padding:20px;border-radius:14px}
    .topbar{display:flex;justify-content:space-between;align-items:center;margin-bottom:12px}
    .btn{padding:8px 14px;border-radius:8px;background:#444;color:#fff;text-decoration:none;font-weight:600}
    .btn:hover{background:#666}
    .stats{display:flex;gap:10px;align-items:center}
    table{width:100%;border-collapse:collapse;margin-top:12px}
    th,td{padding:10px;border-bottom:1px solid #444;text-align:left}
    th{background:#33333300}
    tr:nth-child(even){background:#2a2a2a00}
    .nowrap{white-space:nowrap}
    .addr{max-width:320px;overflow-wrap:break-word}
</style>

</head>
<body><!-- Overlay --><div class="overlay" id="overlay"></div><!-- Sidebar --><div class="sidebar" id="sidebar">
    <ul>
    <li><a href="../siap/index" class="active"><i class="fas fa-th-large"></i> Daftar Hadir</a></li>
    <li><a href="../siap/daftar"><i class="fa-brands fa-github"></i> Data Register</a></li>
    <li><a href="../siap/scan"><i class="fa-solid fa-lock"></i> Scan qrcode</a></li>
    <li><a href="../siap/register"><i class="fa-solid fa-gear"></i> Katalog New daftar </a></li>
  </ul>
</div><!-- Navbar Top --><div id="navbar-top" class="d-flex align-items-center mb-3">
    <span class="menu-btn" id="menu-btn"><i class="fas fa-bars"></i></span>
    <h5 class="text-white m-0">Admin Natal Youth</h5>
</div><!-- Main Content --><div class="glass-card">
  <!-- Seksi Admin Youth Registrations (tanpa mengubah tampilan) -->
  <div class="card">
    <div class="topbar">
      <h2>Admin Youth Registrations</h2>
      <div class="stats">
        <div>Total peserta: <b><?=esc($totalRows)?></b></div>
        <a class="btn" href="?export=xls">Download Excel</a>
      </div>
    </div>
    <table>
      <thead>
        <tr>
          <th>Nama</th>
          <th class="nowrap">WhatsApp</th>
          <th>Gereja</th>
          <th>Alamat</th>
          <th class="nowrap">Tgl Register</th>
        </tr>
      </thead>
      <tbody>
        <?php if (!$rows): ?>
          <tr><td colspan="5">Belum ada data.</td></tr>
        <?php else: foreach ($rows as $r): ?>
          <tr>
            <td><?=esc($r['nama'])?></td>
            <td class="nowrap"><?=esc($r['whatsapp'])?></td>
            <td><?=esc($r['gereja'])?></td>
            <td class="addr"><?=esc($r['alamat'])?></td>
            <td class="nowrap"><?php
                $raw = $r['registered_at'] ?? '';
                echo $raw ? esc(date('d-m-Y H:i', strtotime($raw)) . ' WIB') : '';
            ?></td>
          </tr>
        <?php endforeach; endif; ?>
      </tbody>
    </table>
  </div>
</div><footer style="text-align:center;color:#fff;padding:10px 0;">
  © 2025 SCARD-PROJECT
</footer><!-- Script --><script>
    const menuBtn = document.getElementById('menu-btn');
    const sidebar = document.getElementById('sidebar');
    const overlay = document.getElementById('overlay');

    menuBtn.addEventListener('click', () => {
        sidebar.classList.toggle('active');
        overlay.classList.toggle('active');
    });

    overlay.addEventListener('click', () => {
        sidebar.classList.remove('active');
        overlay.classList.remove('active');
    });

    function copyText(id) {
        const text = document.getElementById(id)?.innerText || '';
        if (!text) return;
        navigator.clipboard.writeText(text).then(() => {
            alert('Teks disalin: ' + text);
        });
    }
</script></body>
</html>
<?php $mysqli->close(); ?>